/****************************************************************************
 
 Nombre: CARGAPCX.C
 Utilidad: Carga en pantalla un archivo .PCX de resolucin 320x200x256 
 Fuente: Revista MQO Nm. 1: Programacin grfica.
 Autores: Ferran Gllego - Manuel Montoto
 Fecha: Marzo 1998
 
 E-mail: cworld@biosys.net
 Web: http://www.biosys.net/cworld
 
 Compilado con xito en Turbo C++ 3.0.Es recomendable ejecutarlo desde fuera
 del IDE de Turbo C++, ya que requiere 64K libres.Complalo y ejecutalo desde
 el DOS si tienes algn problema.

 Este cdigo est pensado para que cualquiera pueda incluirlo en sus aplica-
 ciones.Psaselo a tus amigos, colegas...
 Tambin puedes decir que lo has conseguido en:
 http://www.biosys.net/cworld

****************************************************************************/

#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <conio.h>

unsigned char Paleta[256][3]; /* Array que contendr la paleta de colores
											del PCX */

void Pon_Paleta(void)
{
	unsigned char cont1,c;
	int cont;

	for (cont=0;cont<256;cont++)
		for (cont1=0;cont1<3;cont1++)
			Paleta[cont][cont1]=(Paleta[cont][cont1]>>2); /* Movemos 2 bits
				  hacia la derecha todos los bytes ledos en la paleta del PCX.
				  Los componentes RGB de la paleta se encuentran en los 6 bits
				  de mayor peso de los valores ledos del fichero */

	cont=0;
	cont1=0;

	/* El cdigo que sigue a continuacin pasa el contenido del array "Paleta"
	a la paleta de la VGA */
	for (cont=0;cont<256;cont++)
	{
		outportb (0x03c8,cont);
		for (cont1=0;cont1<3;cont1++)
			outportb (0x03c9,Paleta[cont][cont1]);
	}

	do
	{
		asm {
			mov dx,03c8h
			mov al,cont1
			out dx,al
		}
		c=Paleta[cont][0];
		asm {
			mov dx,03c9h
			mov al,c
			out dx,al
		}
		c=Paleta[cont][1];
		asm {
			mov dx,03c9h
			mov al,c
			out dx,al
		}
		c=Paleta[cont][2];
		asm {
			mov dx,03c9h
			mov al,c
			out dx,al
		}
		cont++;
		cont1++;
	}while (cont<256);
}

/* La siguiente funcin carga el archivo PCX en el buffer que recibe como
parmetro (unsigned char far *buf).Para ello asignaremos previamente 64000
bytes de memoria en la funcin main (*pantalla) */
unsigned char Cargar_PCX (char *name, unsigned char far *buf)
{
	FILE *fp;
	unsigned char bytecount,byte;
	unsigned int i;

	if ((fp=fopen(name,"rb"))==NULL)        return (0);
	fseek (fp,128L,SEEK_SET); /* Nos saltamos la cabecera del PCX */
	i=0;
	while (i<64000) /* Mientras no se coloquen todos los pxels */
	{
		if ((fread(&byte,1,1,fp))==0) break;
		if (byte>0xbf) /* Si es un contador de pxels... */
		{
			bytecount=byte&0x3f; /* Nmero de pxels del siguiente color */
			fread(&byte,1,1,fp); /* Leemos el color */
			while (bytecount>0)  /* Mientras queden pxels del color actual */
			{
				*buf++=byte;      /* Ponemos el pxel en el buffer */
				bytecount--;      /* Restamos uno */
				i++;              /* Hemos puesto un pxel */
			}
		}
		else           /* Si no  era un contador de pxels... */
		{
			*buf++=byte;         /* Ponemos el pxel en el buffer */
			i++;                 /* Hemos puesto un pxel simple */
		}
	}
	fseek(fp,-768L,SEEK_END);  /* Nos situamos en el comienzo de la paleta */
	fread(Paleta,768,1,fp);    /* Leemos los bytes componentes del RGB */
	Pon_Paleta(); /* Llamamos a la funcin que actualiza la paleta en la VGA */
	fclose(fp);   /* Cerramos el fichero */
	return (1);
}

void main(void)
{
	unsigned char far *pantalla;

	asm {
		mov ax,13h     /* Iniciamos el modo */
		int 10h        /* 320x200 con 256 colores */
	}

	pantalla=(unsigned char far *) farmalloc(64000); /* Asignamos 64K bytes */
	Cargar_PCX("PRUEBA.PCX",pantalla); /* Abrimos el fichero */

/* A continuacin volcamos el contenido del puntero en la memoria de vdeo */
	movedata (FP_SEG(pantalla),FP_OFF(pantalla),0xA000,0,64000);
	while (!kbhit());
	asm {
		mov ax,03h     /* Retornamos al modo */
		int 10h        /* texto */
	}
}
